package gov.va.med.mhv.usermgmt.util.mvi;

import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAMT201304UV02Patient;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02Patient;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02Document.PRPAIN201306UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02Document.PRPAIN201310UV02;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MviUtil {
	private static final Log LOG = LogFactory.getLog(MviUtil.class);
	public static String getCreationTime() {
	String creationTime = null;
	
	SimpleDateFormat dateformatYYYYMMDD = new SimpleDateFormat("yyyyMMddHHmmss");
	StringBuilder nowYYYYMMDD = new StringBuilder( dateformatYYYYMMDD.format( new Date() ));
	creationTime = nowYYYYMMDD.toString();
	
	return creationTime;
	}
	
	public static String getMCIDExtension() {
		StringBuilder mCIDExtension = new StringBuilder();
		
		mCIDExtension.append("MCID-");
		
        //mCIDExtension.append(Long.toString(finalUniqueValue));
        
		return mCIDExtension.toString();
	}
	
	public static long getUniqueId() {
		
		UUID idFirst = UUID.randomUUID();
		long uidFirstHashCode = gethashCodeValue(""+idFirst);
		String filterStr=""+uidFirstHashCode;
        String str=filterStr.replaceAll("-", "");
		
        long firstNumber = Long.parseLong(str);
        
        UUID idSecond = UUID.randomUUID();
		long uidSecondHashCode = gethashCodeValue(""+idSecond);
		String filterStr2=""+uidSecondHashCode;
        String str2=filterStr.replaceAll("-", "");
		
        long secondNumber = Long.parseLong(str);
        
        long currentTime = System.currentTimeMillis();
        
        long finalUniqueValue = firstNumber + secondNumber + currentTime;
        
        return finalUniqueValue;
	}
	
	public static long gethashCodeValue(String str) {
	    String str2=""+str;
	    long hashCodeValue = str.hashCode();
        return hashCodeValue;	
	}
	
	public static boolean checkTreatmentFacilitiesExist(List<String> stationNumberArray) {
		boolean isReallyAPatient = false;
	    for (int i=0; i< stationNumberArray.size() ; i++) {
	    	/*
	    	 * Any station number that starts with 200 is a non-treatment facility and 742V1 is a Veterans Id Card system
	    	 */
		    if (!stationNumberArray.get(i).startsWith("200") && !stationNumberArray.get(i).equals("742V1")) {
		    	isReallyAPatient = true;
		    	break;	    			
		    }
	    }
	    return isReallyAPatient;
	}
	public static String getICNfromEdipiSearchResult(PRPAIN201310UV02 searchRes) {
		// Configuration Properties
		MviProperties properties = MviProperties.getInstance();
		PRPAIN201310UV02MFMIMT700711UV01Subject1[] subject1Array = searchRes.getControlActProcess().getSubjectArray();
		PRPAIN201310UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
		PRPAMT201304UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
		II idArray[] = patient.getIdArray();
		for (int i=0; i< idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("NI")) {
				String[] idExtn = searchIdExtension.split("\\^");
				String source = idExtn[2];
				String issuer = idExtn[3];
				if(source.equals("200M") && issuer.equals("USVHA")) {
					String patientICN = idExtn[0];
					return patientICN;
				}
			}
		}
		return null;
	}
	
	/**
	 * This method is to find out whether 200MH exists 1310 response which indicates the user is correlated with an MHV account
	 * @param searchRes
	 * @return DFN
	 */
	public static String getEdipiSearchResult(PRPAIN201310UV02 searchRes) {
		MviProperties properties = MviProperties.getInstance();
		PRPAIN201310UV02MFMIMT700711UV01Subject1[] subject1Array = searchRes.getControlActProcess().getSubjectArray();
		PRPAIN201310UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
		PRPAMT201304UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
		II idArray[] = patient.getIdArray();
		for (int i=0; i< idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains(properties.getMviPatientIdentifier())) {
				String[] idExtn = searchIdExtension.split("\\^");
				String source = idExtn[2];
				String issuer = idExtn[3];
				if(source.equals(properties.getMviReceivingFacilityId()) && issuer.equals(properties.getMviFacilityAssignAuthority())) {
					String patientDFN = idExtn[0];
					return patientDFN;
				}
			}
		}
		return null;
	}
	
	/**
	 * This method is to find out whether 200MH exists 1310 response which indicates the user is correlated with an MHV account
	 * @param searchRes
	 * @return DFN
	 */
	public static String getDFNfromEdipiSearchResultIf200MH(PRPAIN201310UV02 searchRes) {
		MviProperties properties = MviProperties.getInstance();
		PRPAIN201310UV02MFMIMT700711UV01Subject1[] subject1Array = searchRes.getControlActProcess().getSubjectArray();
		
		//JAZZ Story#39187 - US03 When multiple accounts are returned from MVI, MHV should throw a user friendly error message.
		int numberOfDfns = 0;
		PRPAIN201310UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
		PRPAMT201304UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
		II idArray[] = patient.getIdArray();
		for (int i=0; i< idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains(properties.getMviPatientIdentifier())) {
				String[] idExtn = searchIdExtension.split("\\^");
						String source = idExtn[2];
						String issuer = idExtn[3];
					if(source.equals(properties.getMviReceivingFacilityId()) && issuer.equals(properties.getMviFacilityAssignAuthority())) {
							numberOfDfns++;
							if(numberOfDfns>1) {
						if (LOG.isDebugEnabled()) {
							LOG.debug("multiple DFN returning from MVI 1310 Response DFN:"+idExtn[0]);
						}
						return MviConstants.MULTIPLE_IDS_ERROR;
					}
				}
			}
		}
		
		patient = subject1.getRegistrationEvent().getSubject1().getPatient();
		for (int i=0; i< idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains(properties.getMviPatientIdentifier())) {
				String[] idExtn = searchIdExtension.split("\\^");
				String source = idExtn[2];
				String issuer = idExtn[3];
				if(source.equals(properties.getMviReceivingFacilityId()) && issuer.equals(properties.getMviFacilityAssignAuthority())) {
					String patientDFN = idExtn[0];
					return patientDFN;
				}
			}
		}
		return null;
	}
	/**
	 * This method is to find out whether 200MH exists 1306 response which indicates the user is correlated with an MHV account
	 * @param searchRes
	 * @return DFN
	 */
	public static String getDFNfromMVISearchResultIf200MH(PRPAIN201306UV02 searchRes) {
		MviProperties properties = MviProperties.getInstance();
		PRPAIN201306UV02MFMIMT700711UV01Subject1[] subject1Array = searchRes.getControlActProcess().getSubjectArray();

		int numberOfDfns = 0;
		if(subject1Array.length>1) {
			for (int j = 0; j < subject1Array.length; j++) {
				PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[j];
				PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
				II idArray[] = patient.getIdArray();
				for (int i=0; i< idArray.length; i++) {
					II patientId = idArray[i];
					String searchIdExtension = patientId.getExtension();
					if (searchIdExtension.contains(properties.getMviPatientIdentifier())) {
						String[] idExtn = searchIdExtension.split("\\^");
						String source = idExtn[2];
						String issuer = idExtn[3];
						if(source.equals(properties.getMviReceivingFacilityId()) && issuer.equals(properties.getMviFacilityAssignAuthority())) {
							if(idExtn[0]!=null&&idExtn[0].length()>0) {
								numberOfDfns++;
								if(numberOfDfns>1) {
									if (LOG.isDebugEnabled()) {
										LOG.debug("multiple DFN returning from MVI 1310 Response DFN:"+idExtn[0]);
									}
									return MviConstants.MULTIPLE_IDS_ERROR;
								}
							}
						}
					}
				}
				
			}
		}

		
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
		PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
		II idArray[] = patient.getIdArray();	

		for (int i=0; i< idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains(properties.getMviPatientIdentifier())) {
				String[] idExtn = searchIdExtension.split("\\^");
				String source = idExtn[2];
				String issuer = idExtn[3];
				if(source.equals(properties.getMviReceivingFacilityId()) && issuer.equals(properties.getMviFacilityAssignAuthority())) {
					String patientDFN = idExtn[0];
					return patientDFN;
				}
			}
		}
		return null;
	}

}
